package gov.va.caret.model.support;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.model.Assmt;
import gov.va.caret.model.BgLae;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.Docum;
import gov.va.caret.model.Note;
import gov.va.caret.model.Vcg;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.VcgWrapper;
import gov.va.caret.model.Waivr;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.impl.BgLaeImpl;
import gov.va.caret.model.impl.BoxGpImpl;
import gov.va.caret.model.impl.VcgImpl;
import gov.va.caret.model.support.Person.Role;
import gov.va.caret.pdf.FileType;
import gov.va.caret.service.AssmtLocalServiceUtil;
import gov.va.caret.service.BgLaeLocalServiceUtil;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.DocumLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.VcgAnLocalServiceUtil;
import gov.va.caret.service.VcgLocalServiceUtil;
import gov.va.caret.service.WaivrLocalServiceUtil;
import gov.va.caret.service.WorImLocalServiceUtil;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;

import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.LinkedHashMap;

public class VcgSupport extends VcgWrapper {
	
	Veteran veteran = null;
	Person primary = null;
	Person secondary = null;
	Person secondaryTwo = null;
	Person general = null;
	String veteranName = null;
	String primaryName = null;
	String secondaryName = null;
	String secondaryTwoName = null;
	VcgApplication vcgPrimaryApplication = null;
	VcgApplication vcgSecondaryApplication = null;
	VcgApplication vcgSecondaryTwoApplication = null;
	private Map<String,BgLae> customAttributes = new HashMap<String,BgLae>();

	private Waivr primaryWaiver = null;
	private Waivr secondaryWaiver = null;
	private Waivr secondaryTwoWaiver = null;
	private static Log _log = LogFactoryUtil.getLog( VcgSupport.class );
	private Map<String,Note> notes = new HashMap<String,Note>();
	
	public List<DocumentSupport> vcgDocsCurrent = new ArrayList<DocumentSupport>();
	//public List<DocumentSupport> cgDocsCurrent = new ArrayList<DocumentSupport>();
	//public List<DocumentSupport> poaDocsCurrent = new ArrayList<DocumentSupport>();
	public List<DocumentSupport> vcgDocsAll = new ArrayList<DocumentSupport>();
	//public List<DocumentSupport> cgDocsAll = new ArrayList<DocumentSupport>();
	//public List<DocumentSupport> poaDocsAll = new ArrayList<DocumentSupport>();
	
	public List<DocumentSupport> getVcgDocsCurrent() {
		return vcgDocsCurrent;
	}

	public void setVcgDocsCurrent(List<DocumentSupport> vcgDocsCurrent) {
		this.vcgDocsCurrent = vcgDocsCurrent;
	}

	public List<DocumentSupport> getVcgDocsAll() {
		return vcgDocsAll;
	}

	public void setVcgDocsAll(List<DocumentSupport> vcgDocsAll) {
		this.vcgDocsAll = vcgDocsAll;
	}

	private static final long serialVersionUID = 1L;
	
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	
	public static VcgSupport getVeteranVcg ( long veteranId ) {
		VcgSupport support = null;
		try {
			Vcg v = VcgLocalServiceUtil.getVeteranVcg( veteranId );
			if ( v == null ){
				support = new VcgSupport( new VcgImpl() );
				support.setVeteranId( veteranId );
			} else {
				return new VcgSupport(v);
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return support;
	}
	
	public static VcgSupport getVcgSupport ( long vcgId ) {
		VcgSupport support = null;
		try {
			Vcg v = VcgLocalServiceUtil.getVcg( vcgId );
			if ( v == null ){
				support = new VcgSupport( new VcgImpl() );
			} else {
				return new VcgSupport(v);
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return support;
	}

	public VcgSupport(gov.va.caret.model.Vcg vcg) {
		super(vcg);
	}

	public String getVeteranName() {
		if ( veteranName == null ){
			this.veteranName = getFullName( getVeteranId() );
		}
		return veteranName;
	}

	public String getPrimaryName() {
		if ( primaryName == null ){
			this.primaryName = getFullName( getPrimaryId() );
		}
		return primaryName;
	}

	public String getSecondaryName() {
		if ( secondaryName == null ){
			this.secondaryName = getFullName( getSecondaryId() );
		}
		return secondaryName;
	}

	public String getSecondaryTwoName() {
		if ( secondaryTwoName == null ){
			this.secondaryTwoName = getFullName( getSecondaryTwoId() );
		}
		return secondaryTwoName;
	}
	
	public String getFullName ( long persnId ){
		if ( persnId > 0 ){
			return Toolbox.getPersnFullName ( persnId );
		}
		return StringPool.BLANK;
	}
	
	public String getTierEffectiveDateStr() {
		return Toolbox.formatDateCprs( getTierEffectiveDate() );
	}
	
	public void setTierEffectiveDateStr( String dateStr ) {
		try {
			setTierEffectiveDate( (Date) Toolbox.getDateFormatCprs().parseObject(dateStr) );
		} catch (ParseException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}
	
	private Person getPerson ( long persnId ){
		try {
			return new Person( PersnLocalServiceUtil.getPersn( persnId ) );
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return null;
	}
	
	public Veteran getVeteran(){
		if ( getVeteranId() > 0 ){
			if ( veteran == null ){
				veteran = new Veteran( getPerson( getVeteranId() ) );
			} 
		}
		return veteran;
	}
	
	public Person getPrimary(){
		if ( getPrimaryId() > 0 ){
			if ( primary == null ){
				primary = new Primary( getPerson( getPrimaryId() ) );
			} 
		}
		return primary;
	}
	
	public Person getSecondary(){
		if ( getSecondaryId() > 0 ){
			if ( secondary == null ){
				secondary = new Secondary( getPerson ( getSecondaryId() ) );
			}
		}
		return secondary;
	}
	
	public Person getSecondaryTwo(){
		if ( getSecondaryTwoId() > 0 ){
			if ( secondaryTwo == null ){
				secondaryTwo = new SecondaryTwo( getPerson(getSecondaryTwoId()) );
			}
		}
		return secondaryTwo;
	}
	
	public Person getGeneral(){
		if ( getGeneralId() > 0 ){
			if ( general == null ){
				general = new General ( getPerson( getGeneralId() ) );
			}
		}
		return general;
	}
	
	public boolean isGeneralAssignable (){
		if ( getGeneral() == null ){
			return true;
		}
		if ( this.isGeneralApproved() || isInProcess( getGeneralDispReason() )  ){
			return false;
		}
		return true;
	}
	
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> modelAttributes = super.getModelAttributes();  
		if ( getPrimaryDispositionDate() != null ) {
			modelAttributes.put("primaryDispositionDate", Toolbox.getDateFormatCprs().format( getPrimaryDispositionDate() ) );
		}
		if ( getSecondaryDispositionDate() != null ) {
			modelAttributes.put("secondaryDispositionDate", Toolbox.getDateFormatCprs().format( getSecondaryDispositionDate() ) );
		}
		if ( getSecondaryTwoDispositionDate() != null ) {
			modelAttributes.put("secondaryTwoDispositionDate", Toolbox.getDateFormatCprs().format( getSecondaryTwoDispositionDate() ) );
		}
		if ( getGeneralDispositionDate() != null ) {
			modelAttributes.put("generalDispositionDate", Toolbox.getDateFormatCprs().format( getGeneralDispositionDate() ) );
		}
		
		if ( getPrimaryInitDispDate() != null ) {
			modelAttributes.put("primaryInitDispDate", Toolbox.getDateFormatCprs().format( getPrimaryInitDispDate() ) );
		}
		if ( getSecondaryInitDispDate() != null ) {
			modelAttributes.put("secondaryInitDispDate", Toolbox.getDateFormatCprs().format( getSecondaryInitDispDate() ) );
		}
		if ( getSecondaryTwoInitDispDate() != null ) {
			modelAttributes.put("secondaryTwoInitDispDate", Toolbox.getDateFormatCprs().format( getSecondaryTwoInitDispDate() ) );
		}
		if ( getGeneralInitDispDate() != null ) {
			modelAttributes.put("generalInitDispDate", Toolbox.getDateFormatCprs().format( getGeneralInitDispDate() ) );
		}
		
		if ( getTierEffectiveDate() != null ) {
			modelAttributes.put("tierEffectiveDate", Toolbox.getDateFormatCprs().format( getTierEffectiveDate() ) );
		}
		if ( getPrimaryRevocationDate() != null ) {
			modelAttributes.put("primaryRevocationDate", Toolbox.getDateFormatCprs().format( getPrimaryRevocationDate() ) );
		}
		if ( getSecondaryRevocationDate() != null ) {
			modelAttributes.put("secondaryRevocationDate", Toolbox.getDateFormatCprs().format( getSecondaryRevocationDate() ) );
		}
		if ( getSecondaryTwoRevocationDate() != null ) {
			modelAttributes.put("secondaryTwoRevocationDate", Toolbox.getDateFormatCprs().format( getSecondaryTwoRevocationDate() ) );
		}
		if ( getGeneralRevocationDate() != null ) {
			modelAttributes.put("generalRevocationDate", Toolbox.getDateFormatCprs().format( getGeneralRevocationDate() ) );
		}
		for ( String attribute: notes.keySet() ){
			Note note = notes.get(attribute);
			String text = note.getValue();
			modelAttributes.put( attribute, text.substring(0, Math.min(text.length(), 75)) );
		}
		return modelAttributes;
	}
	
	
	private VcgApplication getVcgAn ( long vcgAnId ){
		if ( vcgAnId > 0 )
		try {
			return new VcgApplication( VcgAnLocalServiceUtil.getVcgAn( vcgAnId ) );
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		return null;
	}
	
	public VcgApplication getPersonVcgAn(Person.Role caregiverRole) {
		if ( Person.Role.PRIMARY == caregiverRole ){
			return getPersonVcgAn(getPrimaryId());
		} else if ( caregiverRole == Person.Role.SECONDARY ) {
			return getPersonVcgAn(getSecondaryId());
		} else if ( caregiverRole == Person.Role.SECONDARYTWO ) {
			return getPersonVcgAn(getSecondaryTwoId());
		}
		return null;
	}
	
	public VcgApplication getPersonVcgAn(long persnId) {
		if ( persnId == getPrimaryId() ){
			return getPrimaryVcgAn();
		}
		if ( persnId == getSecondaryId() ){
			return getSecondaryVcgAn();
		}
		if ( persnId == getSecondaryTwoId() ){
			return getSecondaryTwoVcgAn();
		}
		return null;
	}
	
	public VcgApplication getPrimaryVcgAn(){
		if ( vcgPrimaryApplication == null ){
			vcgPrimaryApplication = getVcgAn( getPrimaryVcgAnId() );
		}
		return vcgPrimaryApplication;
	}
	
	public VcgApplication getSecondaryVcgAn(){
		if ( vcgSecondaryApplication == null ){
			vcgSecondaryApplication = getVcgAn( getSecondaryVcgAnId() );
		}
		return vcgSecondaryApplication;
	}
	
	public VcgApplication getSecondaryTwoVcgAn(){
		if ( vcgSecondaryTwoApplication == null ){
			vcgSecondaryTwoApplication = getVcgAn( getSecondaryTwoVcgAnId() );
		}
		return vcgSecondaryTwoApplication;
	}
	
	public boolean isWaiverPrimary(){
		if ( getPrimaryVcgAn() != null ){
			return WorkType.CSC_WAIVER.getDueDate( vcgPrimaryApplication.getApplicationDate() ).compareTo( new Date() ) < 0;
		}
		return false;
	}
	
	public boolean isWaiverSecondary(){
		if ( getSecondaryVcgAn() != null ){
			return WorkType.CSC_WAIVER.getDueDate( vcgSecondaryApplication.getApplicationDate() ).compareTo( new Date() ) < 0;
		}
		return false;
	}
	
	public boolean isWaiverSecondaryTwo(){
		if ( getSecondaryTwoVcgAn() != null ){
			return WorkType.CSC_WAIVER.getDueDate( vcgSecondaryTwoApplication.getApplicationDate() ).compareTo( new Date() ) < 0;
		}
		return false;
	}
	
	public Waivr getPrimaryWaiver() {
		return primaryWaiver;
	}

	public Waivr getSecondaryWaiver() {
		return secondaryWaiver;
	}

	public Waivr getSecondaryTwoWaiver() {
		return secondaryTwoWaiver;
	}

	public boolean isVacoWaiverPrimary(){
		if ( vcgPrimaryApplication == null ){
			vcgPrimaryApplication = getVcgAn( getPrimaryVcgAnId() );
		}
		boolean vacoWaiver = false;
		if ( vcgPrimaryApplication!= null && WorkType.APP_DELAY.getDueDate( vcgPrimaryApplication.getApplicationDate() ).compareTo( new Date() ) < 0 ){
			if ( primaryWaiver != null && primaryWaiver.getCompletionDate() == null ){
				return true;
			}
			try {
				vacoWaiver = true;
				if ( WorImLocalServiceUtil.countByCgWork(getVcgId(), getPrimaryId(), WorkType.APP_DELAY.name()) > 0 ){
					WorIm work = WorImLocalServiceUtil.findByCgWorkLast(getVcgId(), getPrimaryId(), WorkType.APP_DELAY.name());
					if ( work != null ){
						primaryWaiver = WaivrLocalServiceUtil.getWaivr( work.getQueId() );
						if ( primaryWaiver.getCompletionDate() == null ){
							_log.info("WAIVER SUBMITTED....NEED VISN APPROVAL...");
							return true;
						} else { //completed waiver
							if ( WorkType.APP_DELAY.getExpirationDate( primaryWaiver.getCompletionDate() ).before( new Date() ) ){
								_log.info("Expired ....NEED NEW WAIVER...");
								return true;
							} else {
								_log.info("On TIME....DONT NEED NEW WAIVER...");
								return true;
							}
						}
					}
				}
				_log.info("NO VALID VISN WAIVERS FOUND...");
			} catch (ApplicationWorkFlowException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		} else {
			vacoWaiver = false;
		}
		return vacoWaiver;
	}

	public WorIm getWaiverPrimaryWork () throws ApplicationWorkFlowException{
		WorIm worIm = WorImLocalServiceUtil.findByCgWorkLast( getVcgId(), getPrimaryId(), WorkType.APP_DELAY.name() );
		if ( worIm != null && worIm.getDueDate().after( Toolbox.adjustDate( 1.0, new Date(), false ) ) ){
			return worIm;
		}
		 
		return null;
	}
	
	public String getWaiverPrimaryWorkExpires () throws ApplicationWorkFlowException{
		WorIm worIm = WorImLocalServiceUtil.findByCgWorkLast( getVcgId(), getPrimaryId(), WorkType.APP_DELAY.name() );
		if ( worIm != null && worIm.getCompletionDate() != null  ){
			return Toolbox.formatDateCprs( WorkType.APP_DELAY.getExpirationDate( worIm.getCompletionDate() ) );
		}
		 
		return null;
	}
	public WorIm getWaiverSecondaryWork () throws ApplicationWorkFlowException{
		WorIm worIm = WorImLocalServiceUtil.findByCgWorkLast( getVcgId(), getSecondaryId(), WorkType.APP_DELAY.name() );
		if ( worIm != null && worIm.getDueDate().after( Toolbox.adjustDate( 1.0, new Date(), false ) ) ){
			return worIm;
		}
		 
		return null;
	}
	
	public String getWaiverSecondaryWorkExpires () throws ApplicationWorkFlowException{
		WorIm worIm = WorImLocalServiceUtil.findByCgWorkLast( getVcgId(), getSecondaryId(), WorkType.APP_DELAY.name() );
		if ( worIm != null && worIm.getCompletionDate() != null  ){
			return Toolbox.formatDateCprs( WorkType.APP_DELAY.getExpirationDate( worIm.getCompletionDate() ) );
		}
		 
		return null;
	}
	public WorIm getWaiverSecondaryTwoWork () throws ApplicationWorkFlowException{
		WorIm worIm = WorImLocalServiceUtil.findByCgWorkLast( getVcgId(), getSecondaryTwoId(), WorkType.APP_DELAY.name() );
		if ( worIm != null && worIm.getDueDate().after( Toolbox.adjustDate( 1.0, new Date(), false ) ) ){
			return worIm;
		}
		 
		return null;
	}
	
	public String getWaiverSecondaryTwoWorkExpires () throws ApplicationWorkFlowException{
		WorIm worIm = WorImLocalServiceUtil.findByCgWorkLast( getVcgId(), getSecondaryTwoId(), WorkType.APP_DELAY.name() );
		if ( worIm != null && worIm.getCompletionDate() != null  ){
			return Toolbox.formatDateCprs( WorkType.APP_DELAY.getExpirationDate( worIm.getCompletionDate() ) );
		}
		 
		return null;
	}
	
	public boolean isVacoWaiverSecondary(){
		if ( vcgSecondaryApplication == null ){
			vcgSecondaryApplication = getVcgAn( getSecondaryVcgAnId() );
		}
		boolean vacoWaiver = false;
		if ( vcgSecondaryApplication!= null && WorkType.APP_DELAY.getDueDate( vcgSecondaryApplication.getApplicationDate() ).compareTo( new Date() ) < 0 ){
			if ( secondaryWaiver != null && secondaryWaiver.getCompletionDate() == null ){
				return true;
			}
			try {
				vacoWaiver = true;
				if ( WorImLocalServiceUtil.countByCgWork(getVcgId(), getSecondaryId(), WorkType.APP_DELAY.name()) > 0 ){
					WorIm work = WorImLocalServiceUtil.findByCgWorkLast(getVcgId(), getSecondaryId(), WorkType.APP_DELAY.name());
					if ( work != null ){
						secondaryWaiver = WaivrLocalServiceUtil.getWaivr( work.getQueId() );
						if ( secondaryWaiver.getCompletionDate() == null ){
							_log.info("WAIVER SUBMITTED....NEED VISN APPROVAL...");
							return true;
						} else { //completed waiver
							if ( WorkType.APP_DELAY.getExpirationDate( secondaryWaiver.getCompletionDate() ).before( new Date() ) ){
								_log.info("Expired ....NEED NEW WAIVER...");
								return true;
							} else {
								_log.info("On TIME....DONT NEED NEW WAIVER...");
								return true;
							}
						}
					}
				}
				_log.info("NO VALID VISN WAIVERS FOUND...");
			} catch (ApplicationWorkFlowException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		} else {
			vacoWaiver = false;
		}
		return vacoWaiver;
		
		
		
//		return WorkType.APP_DELAY.getDueDate( vcgSecondaryApplication.getApplicationDate() ).compareTo( new Date() ) < 0;
	}
	
	public boolean isVacoWaiverSecondaryTwo(){
		if ( vcgSecondaryTwoApplication == null ){
			vcgSecondaryTwoApplication = getVcgAn( getSecondaryTwoVcgAnId() );
		}
		
		boolean vacoWaiver = false;
		if ( vcgSecondaryTwoApplication!= null && WorkType.APP_DELAY.getDueDate( vcgSecondaryTwoApplication.getApplicationDate() ).compareTo( new Date() ) < 0 ){
			if ( secondaryTwoWaiver != null && secondaryTwoWaiver.getCompletionDate() == null ){
				return true;
			}
			try {
				vacoWaiver = true;
				if ( WorImLocalServiceUtil.countByCgWork(getVcgId(), getSecondaryTwoId(), WorkType.APP_DELAY.name()) > 0 ){
					WorIm work = WorImLocalServiceUtil.findByCgWorkLast(getVcgId(), getSecondaryTwoId(), WorkType.APP_DELAY.name());
					if ( work != null ){
						secondaryTwoWaiver = WaivrLocalServiceUtil.getWaivr( work.getQueId() );
						if ( secondaryTwoWaiver.getCompletionDate() == null ){
							_log.info("WAIVER SUBMITTED....NEED VISN APPROVAL...");
							return true;
						} else { //completed waiver
							if ( WorkType.APP_DELAY.getExpirationDate( secondaryTwoWaiver.getCompletionDate() ).before( new Date() ) ){
								_log.info("Expired ....NEED NEW WAIVER...");
								return true;
							} else {
								_log.info("On TIME....DONT NEED NEW WAIVER...");
								return true;
							}
						}
					}
				}
				_log.info("NO VALID VISN WAIVERS FOUND...");
			} catch (ApplicationWorkFlowException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (PortalException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (SystemException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		} else {
			vacoWaiver = false;
		}
		return vacoWaiver;
		
//		return WorkType.APP_DELAY.getDueDate( vcgSecondaryTwoApplication.getApplicationDate() ).compareTo( new Date() ) < 0;
	}
	
	
	@Override
	public void persist()
		throws com.liferay.portal.kernel.exception.SystemException {
		if ( getVeteranId() == 0 ){
			throw new com.liferay.portal.kernel.exception.SystemException("Veteran ID cannot be 0");
		}
//		if ( getPrimaryId() == 0 && getSecondaryId() == 0 && getSecondaryTwoId() == 0 ){
//			throw new com.liferay.portal.kernel.exception.SystemException("All Caregiver IDs cannot be 0");
//		}
		super.persist();
		saveCustomAttributes();
	}
	
	private BoxGp initCustomAttribute( String attribute ) throws ApplicationWorkFlowException{
		BoxGp custom = new BoxGpImpl();
		custom.setBoxGroup( VcgSupport.class.getName() );
		custom.setBoxSubGroup( String.valueOf( getVcgId() ) );
		custom.setLabel( attribute );  //attribute
//		custom.setViewSequence( sequence );
		try {
			return BoxGpLocalServiceUtil.addBoxGp( custom );
		} catch (SystemException e) {
			throw new ApplicationWorkFlowException ( e );
		}
	}
	private BoxGp getCustomAttribute ( String attribute, long applicationId ) throws ApplicationWorkFlowException {
		List<BoxGp> attributes = BoxGpLocalServiceUtil.getBoxGroups( VcgApplication.class.getName(), String.valueOf( getVcgId() )  );
		BoxGp custom = null;
		if ( attributes.isEmpty() ){
			custom = initCustomAttribute ( attribute );
		} else {
			for ( BoxGp bgAtt : attributes ){
				if ( attribute.equals( bgAtt.getLabel() ) ){ //TODO:
					custom = bgAtt;
				}
			}
		}
		if ( custom == null ){
			custom = initCustomAttribute ( attribute );
		}
		return custom;
	}
	
	private void saveCustomAttributes() {
		if ( !customAttributes.isEmpty() ){
			for ( BgLae value : customAttributes.values() ){
				try {
					CaretLocalServiceUtil.save(value);
				} catch (ApplicationWorkFlowException e) {
					ApplicationWorkFlowException.handleException(e);
				}
			}
		}
		for ( String attribute: notes.keySet() ){
			Note note = notes.get(attribute);
			if ( note.getNoteId() == 0 ) try {
				note.setChainId( getVcgId() );
				notes.put(attribute, CaretLocalServiceUtil.addNote(note));
			} catch (ApplicationWorkFlowException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
	}
	
	public void setNote ( String attribute, String comment, long userId, Date createDate, long groupId ){
		 notes.put( attribute, Toolbox.createNote( createDate, getVcgId(), groupId, userId, comment ) );
	}

	public void useNote( String attribute, Note note ) {
		notes.put( attribute, note );
	}
	
	public Note getNote ( String attribute ){
		if ( notes.containsKey(attribute) ){
			return notes.get(attribute); 
		}
		return null;
	}
	

	private BgLae getLeaAttr ( String attribute, long applicationId ) throws ApplicationWorkFlowException {
		BoxGp custom = getCustomAttribute ( attribute, applicationId );
		BgLae value = BgLaeLocalServiceUtil.getBgLaeAssociation( getVcgId(), custom.getBoxGpId() );
		if ( value == null ){
			value = new BgLaeImpl();
			value.setBoxGpId( custom.getBoxGpId() );
		}
		return value;
	}
	
	public void setInvalidApplication ( long applicationId, String largeText ) {
		try {
			BgLae invalid = null;
			String attr = CaretStrPool.INVALID_APPLICATION + applicationId;
			for ( String key : customAttributes.keySet() ){
				if ( key.equals(attr) ){
					invalid = customAttributes.get(key);
				}
			}
			if ( invalid == null ){
				invalid = getLeaAttr ( attr, applicationId );
				customAttributes.put( attr, invalid );
			}
			invalid.setLargeText( largeText );
			invalid.setOwnerId( applicationId );
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}

	public void setDuplicateApplication(long applicationId, String largeText) {
		try {
			BgLae duplicate = null;
			String attr = CaretStrPool.DUPLICATE_APPLICATION + applicationId;
			for ( String key : customAttributes.keySet() ){
				if ( key.equals(attr) ){
					duplicate = customAttributes.get(key);
				}
			}
			if ( duplicate == null ){
				duplicate = getLeaAttr ( attr, applicationId );
				customAttributes.put( attr, duplicate );
			}
			duplicate.setLargeText( largeText );
			duplicate.setOwnerId( applicationId );
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}
	
	public List<String> getGeneralDispChoices() {
		return getNextDispStates( getGeneralDispReason(), getGeneral(), false );
	}
	
	public List<String> getPrimaryDispChoices() {
		return getNextDispStates( getPrimaryDispReason(), getPrimary(), isPrimaryAssmtComplete() );
	}
	
	public List<String> getSecondaryDispChoices() {
		return getNextDispStates( getSecondaryDispReason(), getSecondary(), isSecondaryAssmtComplete() );
	}
	
	public List<String> getSecondaryTwoDispChoices() {
		return getNextDispStates( getSecondaryTwoDispReason(), getSecondaryTwo(), isSecondaryTwoAssmtComplete()  );
	}
	
	public static String getDisposition ( String state ){
		if ( Toolbox.isEmpty( state ) ){
			return StringPool.BLANK;
		}
		if ( !CaretStrPool.IN_PROCESS.equals( state ) ){
			int end = Math.max( state.indexOf('-'), state.length() ) ;
			return state.substring(0,end-1);
		}
		return state;
	}
	
	public boolean isTierEditEnabled ( ){
		if ( getPrimary() != null ){
			String reason = getPrimaryDispReason();
			return isApproved( reason ) || isReinstated( reason );
		}
		return false;
	}
	
	public boolean isApproved( String reason ){
		return reason != null && reason.equals(CaretStrPool.APPROVED);
	}
	
	public boolean isInProcess( String reason ){
		return reason != null && reason.equals(CaretStrPool.IN_PROCESS);
	}
	
	public boolean isDisapproved( String reason ){
		return reason != null && reason.startsWith(CaretStrPool.DISAPPROVED);
	}
	
	public boolean isRevoked( String reason ){
		return reason != null && reason.startsWith(CaretStrPool.REVOKED);
	}
	
	public boolean isAppealed( String reason ){
		return reason != null && reason.startsWith(CaretStrPool.APPEALED);
	}
	
	public boolean isReinstated( String reason ){
		return reason != null && reason.equals(CaretStrPool.REINSTATED);
	}
	
	public boolean isNew (){
		return getVcgId() == 0;
	}
	
	public long[] getActiveVcgIdsArray ( long persnId ) {
		long[] array = new long[5];
		if ( getVcgId() > 0 ){
			array[0] = getVcgId();
			array[1] = getVeteranId();
			if ( getPrimaryId() > 0 && VcgSupport.isActive( getPrimaryDispReason() ) ){
				array[2] = getPrimaryId();
			}
			if ( getSecondaryId() > 0 && VcgSupport.isActive( getSecondaryDispReason() ) ){
				array[3] = getSecondaryId();
			}
			if ( getSecondaryTwoId() > 0 && VcgSupport.isActive( getSecondaryTwoDispReason() ) ){
				array[4] = getSecondaryTwoId();
			}
			return array;
		}
		return new long[]{ 0, persnId, 0,0,0 };
	}
	
	public static boolean isActive ( String reason ){
		return reason != null && 
			( reason.equals(CaretStrPool.REINSTATED) ||
				reason.startsWith(CaretStrPool.APPEALED) ||
				reason.equals(CaretStrPool.IN_PROCESS) ||
				reason.equals(CaretStrPool.APPROVED) );
	}

	public List<String> getNextDispStates( String state, Person person, boolean assessmentComplete ) {
		List<String> dispStates = new ArrayList<String>();

		if ( isInProcess( state ) ){
			if ( Person.Role.GENERAL == person.getRole() ){
				if ( isApproved( getPrimaryDispReason() ) || isReinstated( getPrimaryDispReason() ) ){
					return Arrays.asList(new String[]{CaretStrPool.DISAPPROVED});
				} else {
					return Arrays.asList(new String[]{CaretStrPool.APPROVED, CaretStrPool.DISAPPROVED});
				}
			} else if ( Person.Role.PRIMARY == person.getRole() ){
				if ( isVacoWaiverPrimary() && ( primaryWaiver != null && (primaryWaiver.getCompletionDate() == null || expiredPrimaryWaiver() ) ) ) {
					return Collections.emptyList();
				} else if ( (isVacoWaiverPrimary() && (primaryWaiver == null || !CaretStrPool.ACCEPTED.equals( primaryWaiver.getAdjudication() ) ) ) 
						|| !assessmentComplete || Toolbox.isEmpty( person.getSsn() ) ||
						!person.isValidUspsAddress() || isApproved( getGeneralDispReason() ) || isReinstated ( getGeneralDispReason() ) ){
					return Arrays.asList(new String[]{CaretStrPool.DISAPPROVED});
				}  else {
					return Arrays.asList(new String[]{CaretStrPool.APPROVED, CaretStrPool.DISAPPROVED});
				}
			} else if ( person.getRole() == Person.Role.SECONDARY ) {
				if ( isVacoWaiverSecondary() && ( secondaryWaiver != null && (secondaryWaiver.getCompletionDate() == null || expiredSecondaryWaiver() ) ) ) {
					return Collections.emptyList();
				} else if ( (isVacoWaiverPrimary() && (secondaryWaiver == null || !CaretStrPool.ACCEPTED.equals( secondaryWaiver.getAdjudication() ) ) ) 
						|| !assessmentComplete || Toolbox.isEmpty( person.getSsn() ) || !person.isValidUspsAddress()  ){
					return Arrays.asList(new String[]{CaretStrPool.DISAPPROVED});
				}  else {
					return Arrays.asList(new String[]{CaretStrPool.APPROVED, CaretStrPool.DISAPPROVED});
				}
			} else if ( person.getRole() == Person.Role.SECONDARYTWO ) {
				if ( isVacoWaiverSecondaryTwo() && ( secondaryTwoWaiver != null && (secondaryTwoWaiver.getCompletionDate() == null || expiredSecondaryTwoWaiver() ) ) ) {
					return Collections.emptyList();
				} else if ( (isVacoWaiverPrimary() && (secondaryTwoWaiver == null || !CaretStrPool.ACCEPTED.equals( secondaryTwoWaiver.getAdjudication() ) ) ) 
						|| !assessmentComplete || Toolbox.isEmpty( person.getSsn() ) || !person.isValidUspsAddress()  ){
					return Arrays.asList(new String[]{CaretStrPool.DISAPPROVED});
				}  else {
					return Arrays.asList(new String[]{CaretStrPool.APPROVED, CaretStrPool.DISAPPROVED});
				}
			}
		} else if ( isApproved( state ) || isReinstated( state ) ){
			return Arrays.asList(new String[]{CaretStrPool.REVOKED});
		} else if ( isRevoked( state ) ){
			if ( Person.Role.GENERAL == person.getRole() ){
				if ( isApproved( getPrimaryDispReason() ) || isReinstated( getPrimaryDispReason() ) ){
					return Arrays.asList(new String[]{CaretStrPool.APPEALED});
				} else {
					return Arrays.asList(new String[]{CaretStrPool.REINSTATED,CaretStrPool.APPEALED});
				}
			} else {
				if ( assessmentComplete && person.isValidUspsAddress() && !Toolbox.isEmpty( person.getSsn() ) &&
						Person.Role.PRIMARY == person.getRole() 
						&& ( isApproved( getGeneralDispReason() ) || isReinstated ( getGeneralDispReason() ) ) ){
					return Arrays.asList(new String[]{CaretStrPool.APPEALED});
				} else if ( assessmentComplete && person.isValidUspsAddress() && !Toolbox.isEmpty( person.getSsn() ) ){
					return Arrays.asList(new String[]{CaretStrPool.REINSTATED,CaretStrPool.APPEALED});
				} else {
					return Arrays.asList(new String[]{CaretStrPool.APPEALED});
				}
			
			}
		} else if ( isAppealed( state ) ){
			if ( assessmentComplete && person.isValidUspsAddress() && !Toolbox.isEmpty( person.getSsn() ) ){
				return Arrays.asList(new String[]{CaretStrPool.REINSTATED,CaretStrPool.DISAPPROVED});
			} else {
				return Arrays.asList(new String[]{CaretStrPool.DISAPPROVED});
			}
		} else if ( isDisapproved( state ) ){
			if ( Person.Role.PRIMARY == person.getRole() ) {
				Date date = Toolbox.adjustDate( Double.valueOf( PortletProps.get("csc.undo.disapprove.days") ), getPrimaryInitDispDate(), true );
				if ( date.after( new Date() ) ){
					return Collections.singletonList(CaretStrPool.IN_PROCESS);
				}
			} else if ( Person.Role.SECONDARY == person.getRole() ){ 
				Date date = Toolbox.adjustDate( Double.valueOf( PortletProps.get("csc.undo.disapprove.days") ), getSecondaryInitDispDate(), true );
				if ( date.after( new Date() ) ){
					return Collections.singletonList(CaretStrPool.IN_PROCESS);
				}
			} else if ( Person.Role.SECONDARYTWO == person.getRole() ){
				Date date = Toolbox.adjustDate( Double.valueOf( PortletProps.get("csc.undo.disapprove.days") ), getSecondaryTwoInitDispDate(), true );
				if ( date.after( new Date() ) ){
					return Collections.singletonList(CaretStrPool.IN_PROCESS);
				}
			} else {
				return Collections.singletonList(CaretStrPool.IN_PROCESS);
			}
			return Collections.emptyList();
		}
		return dispStates;
	}

	public boolean expiredPrimaryWaiver() {
		if ( primaryWaiver == null ){
			return true;
		}
		return WorkType.APP_DELAY.getExpirationDate( primaryWaiver.getCompletionDate() ).before( new Date() );
	}
	
	public boolean expiredSecondaryWaiver() {
		if ( secondaryWaiver == null ){
			return true;
		}
		return WorkType.APP_DELAY.getExpirationDate( secondaryWaiver.getCompletionDate() ).before( new Date() );
	}
	
	public boolean expiredSecondaryTwoWaiver() {
		if ( secondaryTwoWaiver == null ){
			return true;
		}
		return WorkType.APP_DELAY.getExpirationDate( secondaryTwoWaiver.getCompletionDate() ).before( new Date() );
	}

	public boolean isPrimaryApproved(){
		return isApproved( getPrimaryDispReason() ) || isReinstated( getPrimaryDispReason() );
	}
	
	public boolean isSecondaryApproved(){
		return isApproved( getSecondaryDispReason() ) || isReinstated( getSecondaryDispReason() );
	}
	
	public boolean isSecondaryTwoApproved(){
		return isApproved( getSecondaryTwoDispReason() ) || isReinstated( getSecondaryTwoDispReason() );
	}
	
	public boolean isGeneralApproved(){
		return isApproved( getGeneralDispReason() ) || isReinstated( getGeneralDispReason() );
	}

	public boolean isPrimaryAssmtComplete(){
		return primaryAssmtComplete(getVcgId(), getPrimaryId());
	}
	
	public boolean isSecondaryAssmtComplete(){
		return secondaryAssmtComplete(getVcgId(), getSecondaryId());
	}
	
	public boolean isSecondaryTwoAssmtComplete(){
		return secondaryTwoAssmtComplete(getVcgId(), getSecondaryTwoId());
	}
	
	public boolean primaryAssmtComplete(long vcgId, long primaryId)
	{	
		boolean result = false;
		boolean primClinical = false;
		boolean primAssessment = false;
		boolean primTraining= false;
		boolean primInHome = false;

		try {
			List<Assmt>  completedAssessmentList = AssmtLocalServiceUtil.findByVcgId(vcgId);

			for(Assmt assessment:completedAssessmentList)
			{
				if(assessment.isActive())
				{
					if(assessment.getType().equals(CaretStrPool.PRIMARY_CLINICAL) && assessment.getCaregiverId()==primaryId){
						primClinical = true;					
					}else if(assessment.getType().equals(CaretStrPool.PRIMARY_ASSESSMENT) && assessment.getCaregiverId()==primaryId){
						primAssessment = true;
					}else if(assessment.getType().equals(CaretStrPool.PRIMARY_TRAINING) && assessment.getCaregiverId()==primaryId){
						primTraining = true;
					}else if(assessment.getType().equals(CaretStrPool.PRIMARY_IN_HOME) && assessment.getCaregiverId()==primaryId){
						primInHome = true;
					}
				}
			}
			
			if(primClinical && primAssessment && primTraining && primInHome){
				//System.out.println("Primary Assessment complete");
				result = true;
			}else{
				//System.out.println("primary assessment not complete");
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	
		return result;
	}
	
	public boolean secondaryAssmtComplete(long vcgId, long secondaryId)
	{
		boolean result = false;
		boolean secClinical = false;
		boolean secAssessment = false;
		boolean secTraining= false;

		try {
			List<Assmt>  completedAssessmentList = AssmtLocalServiceUtil.findByVcgId(vcgId);

			for(Assmt assessment:completedAssessmentList)
			{
				if(assessment.isActive())
				{
					if(assessment.getType().equals(CaretStrPool.SECONDARY_CLINICAL) && assessment.getCaregiverId()==secondaryId){
						secClinical = true;
					}else if(assessment.getType().equals(CaretStrPool.SECONDARY_ASSESSMENT) && assessment.getCaregiverId()==secondaryId){
						secAssessment = true;
					}else if(assessment.getType().equals(CaretStrPool.SECONDARY_TRAINING) && assessment.getCaregiverId()==secondaryId){
						secTraining = true;
					}
				}
			}
			
			if(secClinical && secAssessment && secTraining){
				//System.out.println("Secondary Assessment complete");
				result = true;
			}else{
				//System.out.println("Secondary assessment not complete");
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		
		return result;
	}
	
	public boolean secondaryTwoAssmtComplete(long vcgId, long secondaryTwoId)
	{
		boolean result = false;
		boolean secTwoClinical = false;
		boolean secTwoAssessment = false;
		boolean secTwoTraining= false;
		try {
			List<Assmt> completedAssessmentList = AssmtLocalServiceUtil.findByVcgId(vcgId);

			for(Assmt assessment:completedAssessmentList)
			{
				if(assessment.isActive())
				{
					if(assessment.getType().equals(CaretStrPool.SECONDARY_TWO_CLINICAL) && assessment.getCaregiverId()==secondaryTwoId){
						secTwoClinical = true;
					}else if(assessment.getType().equals(CaretStrPool.SECONDARY_TWO_ASSESSMENT) && assessment.getCaregiverId()==secondaryTwoId){
						secTwoAssessment = true;
					}else if(assessment.getType().equals(CaretStrPool.SECONDARY_TWO_TRAINING) && assessment.getCaregiverId()==secondaryTwoId){
						secTwoTraining = true;
					}
				}
			}
	
			if(secTwoClinical && secTwoAssessment && secTwoTraining){
				//System.out.println("Secondary Two Assessment complete");
				result = true;
			}else{
				//System.out.println("Secondary Two Assessment not complete");
			}
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}

		return result;
	}
	
	
	public void getSupportingDocData()
	{		
		List<DocumentSupport> allDocSuport = new ArrayList<DocumentSupport>(); 

		try 
		{
			List<VcgAn> allApps = VcgAnLocalServiceUtil.getByVcg(getVcgId());
			List<Long> allAppIds = new ArrayList<Long>();

			for(VcgAn oneApp:allApps){
				allAppIds.add(oneApp.getVcgAnId());
			}
			
			Long[] longIds = allAppIds.toArray(new Long[allAppIds.size()]);
			long[] newLongIds = new long[longIds.length];			
			int i = 0;
			
			for(Long oneLong:longIds)
			{
				newLongIds[i++]=oneLong;
			}
			List<Docum> allDocs;
			if ( newLongIds.length > 0 ){
				allDocs = DocumLocalServiceUtil.findByVcgAnId(newLongIds);
			} else {
				allDocs = Collections.emptyList();
			}
			
			String vcgId = Long.toString(getVcgId());		 
			Map<String, String> vcgIdMap = new HashMap<String, String>();
			vcgIdMap.put("vcgId", vcgId);
			
			List<Map<String, Object>> additionalData = CaretLocalServiceUtil.getReport( "vcgSupportingDocuments", vcgIdMap);

			
			for(Docum oneDoc:allDocs){
				DocumentSupport oneDocSupport = new DocumentSupport(oneDoc);
				allDocSuport.add(oneDocSupport);
				
				long vcgAnId = oneDoc.getClassPk();

				if(getPrimaryId()!= 0 && (getPrimaryVcgAnId() == vcgAnId)){
	            	oneDocSupport.primary = true;
	            }
				if(getSecondaryId()!=0 && (getSecondaryVcgAnId() == vcgAnId)){
					oneDocSupport.secondary = true;
		        }
				if(getSecondaryTwoId()!=0 && (getSecondaryTwoVcgAnId() == vcgAnId)){
					oneDocSupport.secondaryTwo = true;
	            }
								
				String fileName = oneDoc.getName();
				String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
				oneDocSupport.docType = fileType;
							
				oneDocSupport.docSize = (oneDoc.getDocument().length())/1000;
				
				for (Map<String, Object> map : additionalData) {
					
					String docId = "";
				    for (Map.Entry<String, Object> entry : map.entrySet()) {
				        String key = entry.getKey();
				        String value = entry.getValue().toString();
				        
				        //For reference
				        //ndx0 - doc.documId	//ndx1 - vcgAn.vcgAnId	//ndx2 - aud.attribute	//ndx3 - doc.name	//ndx4 - doc.type_	
				        //ndx5 - aud.modifieddate //ndx6 - firstname //ndx7 - lastname

				        //System.out.println("key/value is : "+key+"/"+value);
				        
				        if(key.equals("ndx0") && value.equals(String.valueOf(oneDoc.getDocumId()))){	
				        	docId = value;
				        }
				    }
				    
				    for (Map.Entry<String, Object> entryTemp : map.entrySet()) {
				        String keyTemp = entryTemp.getKey();
				        String valueTemp = entryTemp.getValue().toString();

				        if(docId.equals(String.valueOf(oneDocSupport.getDocumId()))){
				        	//update docsupport
				        	if(keyTemp.equals("ndx5")){
					        	oneDocSupport.setCreationDate(valueTemp);					        	
					        }else if(keyTemp.equals("ndx6")){
					        	oneDocSupport.setCreatedByFirstName(valueTemp);
					        }else if(keyTemp.equals("ndx7")){
					        	oneDocSupport.setCreatedByLastName(valueTemp);					        	
					        }else if(keyTemp.equals("ndx8")){
					        	oneDocSupport.setNote(valueTemp);
					        }
				        }
					}
				}
			}
				
		
			for(DocumentSupport oneDocument:allDocSuport){
				oneDocument.setCreatedByFullName(oneDocument.getCreatedByLastName() +", "+oneDocument.getCreatedByFirstName());
				if(oneDocument.getType().equals(FileType.TEN_TEN_CG.name()) || oneDocument.getType().equals(FileType.CSC_1010.name())){
					oneDocument.setUiDocType(CaretStrPool.DOC_1010CG);
					this.vcgDocsAll.add(oneDocument);
					if(isCurrent(oneDocument.getClassPk(), oneDocument.getDeleted())){
						this.vcgDocsCurrent.add(oneDocument);
					}
				}else if(oneDocument.getType().equals(FileType.POA.name()) || oneDocument.getType().equals(FileType.CSC_POA.name())){
					oneDocument.setUiDocType(CaretStrPool.DOC_POA);
					this.vcgDocsAll.add(oneDocument);
					if(isCurrent(oneDocument.getClassPk(), oneDocument.getDeleted())){
						this.vcgDocsCurrent.add(oneDocument);
					}
				}
			}				
		}catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SQLException e) {
			ApplicationWorkFlowException.handleException(e);
		} 
	}
	
	
	public boolean isCurrent(long vcgAnId, boolean deleted){
		boolean result = false;
		
		if(isPrimaryCurrent(vcgAnId, deleted) 
				|| isSecondaryCurrent(vcgAnId, deleted)
				|| isSecondaryTwoCurrent(vcgAnId, deleted)){
			result = true;
		}
		
		return result;
	}
	
	public boolean isPrimaryCurrent(long vcgAnId, boolean deleted){
		boolean result = false;

		if(getPrimaryId()!= 0 
				&& (getPrimaryVcgAnId() == vcgAnId)
				//&& getPrimaryDispReason()!=null 
				//&& (getPrimaryDispReason().equals(CaretStrPool.IN_PROCESS) || getPrimaryDispReason().equals(CaretStrPool.APPROVED))
				&& (isInProcess(getPrimaryDispReason()) || isApproved(getPrimaryDispReason()) || isReinstated(getPrimaryDispReason()))
				&& !deleted){
        	result = true;
        }
		
		return result;
	}
	
	public boolean isSecondaryCurrent(long vcgAnId, boolean deleted){
		boolean result = false;

		if(getSecondaryId()!=0 
				&& (getSecondaryVcgAnId() == vcgAnId)
				//&& getSecondaryDispReason()!=null 
				//&& (getSecondaryDispReason().equals(CaretStrPool.IN_PROCESS) || getSecondaryDispReason().equals(CaretStrPool.APPROVED))
				&& (isInProcess(getSecondaryDispReason()) || isApproved(getSecondaryDispReason()) || isReinstated(getSecondaryDispReason()))
				&& !deleted){
			result = true;
        }

		return result;
	}

	public boolean isSecondaryTwoCurrent(long vcgAnId, boolean deleted){
		boolean result = false;

		if(getSecondaryTwoId()!=0 
				&& (getSecondaryTwoVcgAnId() == vcgAnId) 
				//&& getSecondaryTwoDispReason()!=null 
				//&& (getSecondaryTwoDispReason().equals(CaretStrPool.IN_PROCESS) || getSecondaryTwoDispReason().equals(CaretStrPool.APPROVED))
				&& (isInProcess(getSecondaryTwoDispReason()) || isApproved(getSecondaryTwoDispReason()) || isReinstated(getSecondaryTwoDispReason()))
				&& !deleted){
			result = true;
        }
		
		return result;
	}

	
	public Map<String,Object> getPrimaryDispReasons() {
		Map<String,Object> map = new LinkedHashMap<String,Object>();
		if ( isInProcess( getPrimaryDispReason() )  || isRevoked( getPrimaryDispReason() ) ){
			for ( String reason : PortletProps.getArray("primary-reasons") ){
				map.put(reason, reason); 
			}
		} else if ( isApproved( getPrimaryDispReason() ) || isReinstated( getPrimaryDispReason() ) ){
			for ( String reasonSection: PortletProps.getArray("revocation-reasons") ){
				if ( Toolbox.isEmpty( PortletProps.get(reasonSection) ) ){
					map.put(reasonSection, reasonSection);
				} else {
					map.put(reasonSection, true);
					for ( String reason : PortletProps.getArray(reasonSection) ){
						map.put(reason, reason);
					}
				}
			}
		}
		return map;
	}

	public Object getSecondaryDispReasons() {
		Map<String,Object> map = new LinkedHashMap<String,Object>();
		if ( isInProcess( getSecondaryDispReason() )  || isRevoked( getSecondaryDispReason() ) ){
			for ( String reason : PortletProps.getArray("secondary-reasons") ){
				map.put(reason, reason); 
			}
		} else if ( isApproved( getSecondaryDispReason() ) || isReinstated( getSecondaryDispReason() ) ){
			for ( String reasonSection: PortletProps.getArray("revocation-reasons") ){
				if ( Toolbox.isEmpty( PortletProps.get(reasonSection) ) ){
					map.put(reasonSection, reasonSection);
				} else {
					map.put(reasonSection, true);
					for ( String reason : PortletProps.getArray(reasonSection) ){
						map.put(reason, reason);
					}
				}
			}
		}
		return map;
	}

	public Object getSecondaryTwoDispReasons() {
		Map<String,Object> map = new LinkedHashMap<String,Object>();
		if ( isInProcess( getSecondaryTwoDispReason() )  || isRevoked( getSecondaryTwoDispReason() ) ){
			for ( String reason : PortletProps.getArray("secondaryTwo-reasons") ){
				map.put(reason, reason); 
			}
		} else if ( isApproved( getSecondaryTwoDispReason() ) || isReinstated( getSecondaryTwoDispReason() ) ){
			for ( String reasonSection: PortletProps.getArray("revocation-reasons") ){
				if ( Toolbox.isEmpty( PortletProps.get(reasonSection) ) ){
					map.put(reasonSection, reasonSection);
				} else {
					map.put(reasonSection, true);
					for ( String reason : PortletProps.getArray(reasonSection) ){
						map.put(reason, reason);
					}
				}
			}
		}
		return map;
	}
	
	public Object getGeneralDispReasons() {
		Map<String,Object> map = new LinkedHashMap<String,Object>();
		if ( isInProcess( getGeneralDispReason() ) || isRevoked( getGeneralDispReason() ) ){
			for ( String reason : PortletProps.getArray("general-reasons") ){
				map.put(reason, reason); 
			}
		} else if ( isApproved( getGeneralDispReason() ) || isReinstated( getGeneralDispReason() )  ){
			for ( String reasonSection: PortletProps.getArray("general-revocation-reasons") ){
				if ( Toolbox.isEmpty( PortletProps.get(reasonSection) ) ){
					map.put(reasonSection, reasonSection);
				} else {
					map.put(reasonSection, true);
					for ( String reason : PortletProps.getArray(reasonSection) ){
						map.put(reason, reason);
					}
				}
			}
		}
		return map;
	}

	public void setNewPrimary(long primaryId, String primaryRelationship, long vcgAnId) {
		setPrimaryVcgAnId(vcgAnId);
		setPrimaryType(primaryRelationship);
		setPrimaryId(primaryId);
		setPrimaryDispReason(CaretStrPool.IN_PROCESS);
		setPrimaryInitDispDate(null);
		setPrimaryDispositionDate(null);
		setPrimaryRevocationDate(null);
	}

	public void setNewSecondary(long secondaryId, String secondaryRelationship, long vcgAnId) {
		setSecondaryVcgAnId(vcgAnId);
		setSecondaryType(secondaryRelationship);
		setSecondaryId(secondaryId);
		setSecondaryDispReason(CaretStrPool.IN_PROCESS);
		setSecondaryInitDispDate(null);
		setSecondaryDispositionDate(null);
		setSecondaryRevocationDate(null);
	}

	public void setNewSecondaryTwo(long secondaryTwoId, String secondaryTwoRelationship, long vcgAnId) {
		setSecondaryTwoVcgAnId(vcgAnId);
		setSecondaryTwoType(secondaryTwoRelationship);
		setSecondaryTwoId(secondaryTwoId);
		setSecondaryTwoDispReason(CaretStrPool.IN_PROCESS);
		setSecondaryTwoInitDispDate(null);
		setSecondaryTwoDispositionDate(null);
		setSecondaryTwoRevocationDate(null);
	}
	
	public void setNewGeneral(long generalId, String generalRelationship) {
		setGeneralType(generalRelationship);
		setGeneralId(generalId);
		setGeneralDispReason(CaretStrPool.IN_PROCESS);
		setGeneralInitDispDate(null);
		setGeneralDispositionDate(null);
		setGeneralRevocationDate(null);
	}
	
	public WorkType getDispositionWork ( String dispReason ){
		if ( isApproved( dispReason ) ){
			return WorkType.DISP_APPROVED;
		}
		if ( isRevoked(dispReason) ){
			return WorkType.DISP_REVOKED;
		}
		if ( isReinstated(dispReason) ){
			return WorkType.DISP_REINSTATED;
		}
		return null;
	}
	
	public void setPrimaryDispositionDate( Date date ){
		super.setPrimaryDispositionDate( date );
		if ( getPrimaryInitDispDate() == null ){
			setPrimaryInitDispDate( date );
		}
	}
	
	public void setSecondaryDispositionDate( Date date ){
		super.setSecondaryDispositionDate( date );
		if ( getSecondaryInitDispDate() == null ){
			setSecondaryInitDispDate( date );
		}
	}
	
	public void setSecondaryTwoDispositionDate( Date date ){
		super.setSecondaryTwoDispositionDate( date );
		if ( getSecondaryTwoInitDispDate() == null ){
			setSecondaryTwoInitDispDate( date );
		}
	}

	public long getPersonId(Role caregiverRole) {
		if ( Person.Role.PRIMARY == caregiverRole ){
			return getPrimaryId();
		} else if ( caregiverRole == Person.Role.SECONDARY ) {
			return getSecondaryId();
		} else if ( caregiverRole == Person.Role.SECONDARYTWO ) {
			return getSecondaryTwoId();
		}
		return 0;
	}
	
	public Person getPerson(Role caregiverRole) {
		if ( Person.Role.PRIMARY == caregiverRole ){
			return getPrimary();
		} else if ( caregiverRole == Person.Role.SECONDARY ) {
			return getSecondary();
		} else if ( caregiverRole == Person.Role.SECONDARYTWO ) {
			return getSecondaryTwo();
		}
		return null;
	}

	public Date geVeteranAssessmentCompletionDate() {
		// TODO Auto-generated method stub
		
		return new Date();
	}

	public Date getCaregiverAssessmentCompletionDate(Role role) throws ApplicationWorkFlowException {
		if ( role != Person.Role.VETERAN && role != Person.Role.GENERAL ){
			List<Assmt>  completedAssessmentList = AssmtLocalServiceUtil.findByAssmtTypes(getVcgId(), new String[]{ role.getLabel() + "Assessment" } );
			if ( completedAssessmentList != null && !completedAssessmentList.isEmpty() ){
				return completedAssessmentList.get(0).getCompletionDate();
			}
		}
		return new Date();
	}

	public Date getCaregiverTrainingCompletionDate(Role role) throws ApplicationWorkFlowException {
		if ( role != Person.Role.VETERAN && role != Person.Role.GENERAL ){
			List<Assmt>  completedAssessmentList = AssmtLocalServiceUtil.findByAssmtTypes(getVcgId(), new String[]{ role.getLabel() + "Training" } );
			if ( completedAssessmentList != null && !completedAssessmentList.isEmpty() ){
				return completedAssessmentList.get(0).getCompletionDate();
			}
		}
		return new Date();
	}

	public Date getInHomeCompletionDate(Role role) throws ApplicationWorkFlowException {
		if ( role != Person.Role.VETERAN && role != Person.Role.GENERAL ){
			List<Assmt>  completedAssessmentList = AssmtLocalServiceUtil.findByAssmtTypes(getVcgId(), new String[]{ role.getLabel() + "InHome" } );
			if ( completedAssessmentList != null && !completedAssessmentList.isEmpty() ){
				return completedAssessmentList.get(0).getCompletionDate();
			}
		}
		return new Date();
	}
	
	public Date getClinicalCompletionDate(Role role) throws ApplicationWorkFlowException {
		if ( role != Person.Role.VETERAN && role != Person.Role.GENERAL ){
			List<Assmt>  completedAssessmentList = AssmtLocalServiceUtil.findByAssmtTypes(getVcgId(), new String[]{ role.getLabel() + "Clinical" } );
			if ( completedAssessmentList != null && !completedAssessmentList.isEmpty() ){
				return completedAssessmentList.get(0).getCompletionDate();
			}
		}
		return new Date();
	}
	
	
	
}
